@php
    $show_ai = auth()->check();
    $pos_segment_1 = request()->segment(1);
    $pos_segment_2 = request()->segment(2);
    $pos_segment_3 = request()->segment(3);
    $is_pos_heavy = $pos_segment_1 === 'pos' && in_array(($pos_segment_2 ?? ''), ['create', 'payment']) || ($pos_segment_3 === 'edit');
    $show_ai = $show_ai && !$is_pos_heavy;
@endphp

@if ($show_ai)
<style>
  .ai-fab{position:fixed;right:20px;bottom:20px;z-index:99999;display:flex;align-items:center;justify-content:center;width:48px;height:48px;border-radius:9999px;background:#2563eb;color:#fff;box-shadow:0 6px 16px rgba(0,0,0,.2);cursor:pointer}
  .ai-panel{position:fixed;right:20px;bottom:80px;width:360px;max-width:92vw;height:480px;max-height:70vh;z-index:99998;background:#fff;border-radius:12px;box-shadow:0 10px 30px rgba(0,0,0,.25);display:none;overflow:hidden;border:1px solid #e5e7eb}
  .ai-panel.open{display:flex;flex-direction:column}
  .ai-panel header{background:#1f2937;color:#fff;padding:10px 12px;display:flex;align-items:center;justify-content:space-between}
  .ai-panel header .title{font-weight:600;font-size:14px}
  .ai-panel header button{background:transparent;border:0;color:#fff;cursor:pointer;font-size:16px;line-height:1;padding:4px 6px;border-radius:6px}
  .ai-panel header button:hover{background:rgba(255,255,255,0.12)}
  .ai-chat-body{flex:1;padding:10px;background:#f8fafc;overflow:auto}
  .ai-msg{margin:8px 0;display:flex}
  .ai-msg.user{justify-content:flex-end}
  .ai-bubble{max-width:80%;padding:8px 10px;border-radius:10px;font-size:14px;line-height:1.35}
  .ai-msg.user .ai-bubble{background:#2563eb;color:#fff;border-bottom-right-radius:2px}
  .ai-msg.assistant .ai-bubble{background:#eef2ff;color:#111827;border-bottom-left-radius:2px}
  .ai-input{display:flex;gap:8px;padding:10px;background:#fff;border-top:1px solid #e5e7eb}
  .ai-input input{flex:1;border:1px solid #e5e7eb;border-radius:8px;padding:8px 10px}
  .ai-input button{background:#2563eb;border:0;color:#fff;padding:8px 12px;border-radius:8px;cursor:pointer}
  .ai-rate{font-size:12px;color:#6b7280;margin-top:4px}
  .ai-rate button{background:transparent;border:0;cursor:pointer;margin-right:6px}
</style>
<style>
  /* Assistant table rendering */
  .ai-bubble .ai-table{ margin:6px 0; }
  .ai-bubble .ai-table-caption{ font-weight:600; margin-bottom:4px; }
  .ai-bubble .ai-table table{ width:100%; border-collapse:collapse; font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; font-size:12px; }
  .ai-bubble .ai-table th,.ai-bubble .ai-table td{ border:1px solid #c7d2fe; padding:4px 6px; text-align:left; }
  .ai-bubble .ai-table thead th{ background:#e0e7ff; }
  .ai-bubble .ai-table tbody tr:nth-child(even){ background:#f3f4f6; }
</style>

<div id="ai-fab" class="ai-fab" title="AI Assistant">
  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
  <span class="tw-sr-only">Open AI Assistant</span>
  </div>

<section id="ai-panel" class="ai-panel" aria-label="AI Assistant">
  <header>
    <div class="title">AI Assistant</div>
    <div>
      <button id="ai-minimize" title="Minimize">–</button>
      <button id="ai-close" title="Close">×</button>
    </div>
  </header>
  <div class="ai-langbar" style="padding:6px 10px;background:#111827;color:#fff;border-bottom:1px solid #374151;display:flex;align-items:center;gap:8px">
    <span style="font-size:12px;opacity:0.9">Language:</span>
    @php $aiLang = session('ai_chat.lang_pref', 'en'); @endphp
    <select id="ai-lang" style="background:#111827;color:#fff;border:1px solid rgba(255,255,255,0.3);border-radius:6px;padding:3px 6px;font-size:12px">
      <option value="en" {{ $aiLang==='en' ? 'selected' : '' }}>EN</option>
      <option value="tl" {{ $aiLang==='tl' ? 'selected' : '' }}>TL</option>
      <option value="ceb" {{ $aiLang==='ceb' ? 'selected' : '' }}>CEB</option>
    </select>
  </div>
  <div id="ai-chat-body" class="ai-chat-body" role="log" aria-live="polite"></div>
  <form id="ai-form" class="ai-input">
    <input id="ai-input" type="text" placeholder="Ask something about your data..." maxlength="4000" required>
    <button type="submit">Send</button>
  </form>
</section>

<script>
(function(){
  const fab = document.getElementById('ai-fab');
  const panel = document.getElementById('ai-panel');
  const body = document.getElementById('ai-chat-body');
  const form = document.getElementById('ai-form');
  const input = document.getElementById('ai-input');
  const btnClose = document.getElementById('ai-close');
  const btnMin = document.getElementById('ai-minimize');
  const selLang = document.getElementById('ai-lang');
  const CSRF = (document.querySelector('meta[name="csrf-token"]')||{}).getAttribute?.('content');

  function open(){ panel.classList.add('open'); localStorage.setItem('ai_widget_open','1'); setTimeout(()=>input?.focus?.(), 100); }
  function close(){ panel.classList.remove('open'); localStorage.setItem('ai_widget_open','0'); }
  function add(role, text, meta={}){
    const row = document.createElement('div'); row.className = 'ai-msg '+role;
    const b = document.createElement('div'); b.className = 'ai-bubble';
    // Optional: render simple table blocks from assistant safely
    if(role==='assistant' && typeof text==='string' && text.startsWith('::table::')){
      try{
        const container = document.createElement('div');
        const regex = /::table::([\s\S]*?)::endtable::/g; let m;
        while((m = regex.exec(text))){
          const block = m[1] || '';
          const lines = block.split(/\r?\n/).map(s=>s.trim()).filter(Boolean);
          if(lines.length===0) continue;
          const caption = lines.shift();
          const headerLine = (lines.length>0 && lines[0].includes('|')) ? lines.shift() : 'Group|Price';
          const headers = headerLine.split('|').map(s=>s.trim());
          const wrap = document.createElement('div'); wrap.className='ai-table';
          const cap = document.createElement('div'); cap.className='ai-table-caption'; cap.textContent = caption; wrap.appendChild(cap);
          const tbl = document.createElement('table');
          const thead = document.createElement('thead'); const trh = document.createElement('tr');
          headers.forEach(h=>{ const th=document.createElement('th'); th.textContent=h; trh.appendChild(th); });
          thead.appendChild(trh); tbl.appendChild(thead);
          const tbody = document.createElement('tbody');
          lines.forEach(line=>{
            if(!line.includes('|')) return; const tr=document.createElement('tr');
            line.split('|').forEach(cell=>{ const td=document.createElement('td'); td.textContent=cell.trim(); tr.appendChild(td); });
            tbody.appendChild(tr);
          });
          tbl.appendChild(tbody); wrap.appendChild(tbl); container.appendChild(wrap);
        }
        b.appendChild(container);
      }catch(e){ b.textContent = text; }
    } else {
      b.textContent = text;
    }
    row.appendChild(b);
    if(role==='assistant' && meta.message_id){
      const rate = document.createElement('div'); rate.className = 'ai-rate';
      const up = document.createElement('button'); up.textContent = '👍';
      const down = document.createElement('button'); down.textContent = '👎';
      const disable = ()=>{ up.disabled=true; down.disabled=true; };
      const thank = ()=>{ const t=document.createElement('span'); t.textContent='  Thanks!'; rate.appendChild(t); };
      up.addEventListener('click', async()=>{ disable(); try{ const r=await fetch("{{ url('/ai-chat/rate') }}", { method:'POST', headers:{'Content-Type':'application/json','X-CSRF-TOKEN':CSRF}, body: JSON.stringify({ id: meta.message_id, rating: 1 }) }); if(r.ok) thank(); }catch(e){} });
      down.addEventListener('click', async()=>{ disable(); try{ const r=await fetch("{{ url('/ai-chat/rate') }}", { method:'POST', headers:{'Content-Type':'application/json','X-CSRF-TOKEN':CSRF}, body: JSON.stringify({ id: meta.message_id, rating: -1 }) }); if(r.ok) thank(); }catch(e){} });
      rate.appendChild(up); rate.appendChild(down); row.appendChild(rate);
    }
    body.appendChild(row); body.scrollTop = body.scrollHeight;
  }

  fab?.addEventListener('click', open);
  btnClose?.addEventListener('click', close);
  btnMin?.addEventListener('click', ()=>{ panel.classList.remove('open'); });
  selLang?.addEventListener('change', async ()=>{
    try{
      const val = selLang.value;
      const r = await fetch("{{ url('/ai-chat/lang') }}", { method:'POST', headers:{'Content-Type':'application/json','X-CSRF-TOKEN':CSRF}, body: JSON.stringify({ lang: val }) });
      if(r.ok){
        const toast=document.createElement('div'); toast.textContent='Language set to '+val.toUpperCase();
        toast.style.position='fixed'; toast.style.right='24px'; toast.style.bottom='72px'; toast.style.background='#111827'; toast.style.color='#fff'; toast.style.padding='6px 10px'; toast.style.borderRadius='6px'; toast.style.fontSize='12px'; toast.style.opacity='0.95';
        document.body.appendChild(toast); setTimeout(()=>toast.remove(), 1400);
      }
    }catch(e){}
  });

  // Daily KJV Verse card (always show) with close (per-day hide)
  const todayStr = new Date().toISOString().slice(0,10);
  const verseHide = localStorage.getItem('ai_verse_hide_date');
  if(verseHide !== todayStr){
    const verseCard = document.createElement('div');
    verseCard.id='ai-verse-card';
    verseCard.style.position='fixed'; verseCard.style.right='88px'; verseCard.style.bottom='20px';
    verseCard.style.zIndex='99998'; verseCard.style.maxWidth='320px';
    verseCard.style.background='#fff'; verseCard.style.border='1px solid #e5e7eb'; verseCard.style.borderRadius='10px'; verseCard.style.boxShadow='0 6px 16px rgba(0,0,0,.12)';
    verseCard.style.padding='10px 12px'; verseCard.style.fontSize='13px'; verseCard.style.lineHeight='1.35';
    verseCard.innerHTML='<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:4px;"><div style="font-weight:600;">Daily Verse (KJV)</div><button id="ai-verse-close" title="Hide for today" style="background:transparent;border:0;font-size:16px;cursor:pointer;line-height:1">×</button></div><div id="ai-verse-text">Loading…</div><div id="ai-verse-ref" style="margin-top:4px;color:#6b7280"></div>';
    document.body.appendChild(verseCard);
    const closeVerse = document.getElementById('ai-verse-close');
    closeVerse?.addEventListener('click', ()=>{ localStorage.setItem('ai_verse_hide_date', todayStr); verseCard.remove(); });
    fetch("{{ url('/ai-chat/daily-verse') }}").then(r=>r.json()).then(d=>{
      if(d && d.ok){
        const t=document.getElementById('ai-verse-text'); if(t) t.textContent = d.text;
        const rf=document.getElementById('ai-verse-ref'); if(rf) rf.textContent = d.reference + (d.translation?(' • '+d.translation):'');
      } else {
        const t=document.getElementById('ai-verse-text'); if(t) t.textContent = 'The LORD is my shepherd; I shall not want.';
        const rf=document.getElementById('ai-verse-ref'); if(rf) rf.textContent = 'Psalm 23:1 • KJV';
      }
    }).catch(()=>{
      const t=document.getElementById('ai-verse-text'); if(t) t.textContent = 'The LORD is my shepherd; I shall not want.';
      const rf=document.getElementById('ai-verse-ref'); if(rf) rf.textContent = 'Psalm 23:1 • KJV';
    });
  }

  form?.addEventListener('submit', async (e)=>{
    e.preventDefault();
    const msg = input.value.trim(); if(!msg) return;
    add('user', msg); input.value='';
    const btn = form.querySelector('button[type="submit"]'); const old=btn.textContent; btn.textContent='…'; btn.disabled=true;
    try{
      const metaSupId = document.querySelector('meta[name="current-supplier-id"]');
      const metaSupName = document.querySelector('meta[name="current-supplier-name"]');
      const pageSupplierId = metaSupId ? parseInt(metaSupId.getAttribute('content')||'0',10) : 0;
      const pageSupplierName = metaSupName ? (metaSupName.getAttribute('content')||'') : '';
      const payload = { message: msg };
      if(pageSupplierId>0) payload.page_supplier_id = pageSupplierId;
      if(pageSupplierName) payload.page_supplier_name = pageSupplierName;
      const res = await fetch("{{ url('/ai-chat/message') }}", { method:'POST', headers:{ 'Content-Type':'application/json','X-CSRF-TOKEN':CSRF,'Accept':'application/json' }, body: JSON.stringify(payload) });
      const data = await res.json();
      add('assistant', data && data.reply ? data.reply : 'Sorry, no response.', { message_id: data && data.message_id });
    }catch(err){ add('assistant','Sorry, something went wrong.'); }
    finally{ btn.textContent=old; btn.disabled=false; }
  });

  if(localStorage.getItem('ai_widget_open')==='1'){ open(); }
})();
</script>
@endif
